/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.std;

import com.quantumdata.std.IQDConsole;
import com.quantumdata.std.IRemoteConnection;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.std.InstrumentNotificationHandler;
import com.quantumdata.std.InstrumentResponse;
import com.quantumdata.std.NotificationDispatcher;
import com.quantumdata.std.SystemConsole;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class RemoteInstrument {
    private IRemoteConnection m_connection;
    private RcvThread m_receiver;
    private byte[] m_recvBuffer;
    private final int RECV_MAX = 256;
    private StringBuffer m_respBuffer;
    private InstrumentResponse m_resp;
    private boolean m_echoComplete;
    private boolean m_respComplete;
    private boolean m_promptComplete;
    private boolean m_waiting;
    private NotificationDispatcher m_notDispatcher;
    private Vector<InstrumentNotificationHandler> m_notHandlers;
    private final int DEFAULT_TIMEOUT_MS = 10000;
    private boolean m_debug = false;
    private IQDConsole m_console;

    public RemoteInstrument(IRemoteConnection iRemoteConnection, IQDConsole iQDConsole) {
        this.m_connection = iRemoteConnection;
        this.m_console = iQDConsole;
        if (iQDConsole == null) {
            this.m_console = new SystemConsole();
        }
        this.m_recvBuffer = new byte[256];
        this.m_respComplete = true;
        this.m_promptComplete = true;
        this.m_resp = new InstrumentResponse("", false);
        this.m_respBuffer = new StringBuffer(1024);
        this.m_notHandlers = new Vector();
        this.m_notDispatcher = null;
    }

    public void connect() throws InstrumentException {
        if (this.isConnected()) {
            return;
        }
        if (this.m_connection == null) {
            throw new InstrumentException("No Connection Context Found.");
        }
        try {
            this.m_connection.connect();
        }
        catch (Exception exception) {
            this.printMsg(exception.getMessage());
            throw new InstrumentException(exception.getMessage());
        }
        this.printMsg("Connected");
        this.m_notDispatcher = new NotificationDispatcher(this.m_notHandlers);
        this.m_notDispatcher.start();
        this.m_receiver = new RcvThread();
        this.m_receiver.start();
    }

    public boolean isConnected() {
        if (this.m_connection != null) {
            return this.m_connection.isConnected();
        }
        return false;
    }

    public IRemoteConnection getConnection() {
        return this.m_connection;
    }

    public String getErrorMessage() {
        if (this.m_connection != null) {
            return this.m_connection.getErrorMessage();
        }
        return "";
    }

    public void setConnection(IRemoteConnection iRemoteConnection) {
        if (this.m_connection != null && this.m_connection.isConnected()) {
            this.disconnect();
        }
        this.m_connection = iRemoteConnection;
    }

    public void setConsole(IQDConsole iQDConsole) {
        this.m_console = iQDConsole;
    }

    public void disconnect() {
        if (!this.isConnected()) {
            return;
        }
        try {
            this.m_connection.disconnect();
            this.m_receiver.join();
            this.m_notDispatcher = null;
        }
        catch (Exception exception) {
            this.printMsg(exception.getMessage());
            return;
        }
        this.printMsg("Disconnected");
    }

    public void addNotificationHandler(InstrumentNotificationHandler instrumentNotificationHandler) {
        this.m_notHandlers.add(instrumentNotificationHandler);
    }

    public InstrumentResponse sendCmdAltChannel(String string, int n) {
        IRemoteConnection iRemoteConnection = this.m_connection.getAlternateChannel();
        if (iRemoteConnection == null) {
            String string2 = "Alternate channel not available";
            this.printMsg(string2);
            return new InstrumentResponse(string2, true);
        }
        RemoteInstrument remoteInstrument = new RemoteInstrument(iRemoteConnection, this.m_console);
        try {
            remoteInstrument.connect();
        }
        catch (InstrumentException instrumentException) {
            String string3 = "Can not establish alternate instrument connection: " + instrumentException.getMessage();
            this.printMsg(string3);
            return new InstrumentResponse(string3, true);
        }
        InstrumentResponse instrumentResponse = remoteInstrument.send(string, n);
        remoteInstrument.disconnect();
        return instrumentResponse;
    }

    public synchronized InstrumentResponse sendCmd(String string) {
        return this.sendCmd(string, 0);
    }

    public synchronized InstrumentResponse sendCmd(String string, int n) {
        if (!this.isConnected()) {
            this.printMsg("ERROR: Not Connected!");
            return new InstrumentResponse("ERROR: Not Connected", true);
        }
        return this.send(string, n);
    }

    protected void printMsg(String string) {
        if (this.m_console != null) {
            this.m_console.println(string);
        }
    }

    private InstrumentResponse send(String string, int n) {
        int n2 = 0;
        try {
            this.clearResponse();
            this.m_waiting = true;
            OutputStream outputStream = this.m_connection.getOutputStream();
            if (this.m_debug) {
                System.out.println("S-->: " + string);
            }
            this.m_echoComplete = !this.m_connection.isEchoing();
            this.m_promptComplete = true;
            String string2 = string + "\r\n";
            outputStream.write(string2.getBytes());
            int n3 = n == 0 ? 200 : n / 50;
            while (!this.m_respComplete) {
                Thread.sleep(50L);
                if (++n2 <= n3) continue;
                this.printMsg("ERROR: Send Timeout");
                this.clearResponse();
                return new InstrumentResponse("ERROR: Send Timeout", true);
            }
        }
        catch (Exception exception) {
            this.printMsg("ERROR: Send Exception " + exception.getMessage());
            this.clearResponse();
            return new InstrumentResponse("ERROR: Send Exception " + exception.getMessage(), true);
        }
        return this.m_resp;
    }

    private void clearResponse() {
        this.m_respComplete = false;
        this.m_echoComplete = false;
        this.m_waiting = false;
    }

    public void receive() {
        try {
            InputStream inputStream = this.m_connection.getInputStream();
            while (this.m_connection.isConnected()) {
                int n = inputStream.read(this.m_recvBuffer);
                if (n < 0) {
                    this.m_connection.disconnect();
                    this.m_notDispatcher.deactivate();
                    this.m_notDispatcher.join();
                    break;
                }
                if (n > 0) {
                    String string = new String(this.m_recvBuffer, 0, n);
                    if (this.m_debug) {
                        System.out.println("R-->: " + string);
                    }
                    this.m_respBuffer.append(string);
                    this.ProcessBuffer();
                }
                Thread.sleep(50L);
            }
            this.printMsg("Disconnected");
        }
        catch (Exception exception) {
            this.printMsg("ERROR RCV: " + exception.getMessage());
        }
    }

    private void ProcessBuffer() {
        String string = this.m_echoComplete ? (this.m_promptComplete ? this.m_connection.getEndOfResponse() : this.m_connection.getEndOfPrompt()) : "\r\n";
        int n = this.m_respBuffer.indexOf(string);
        while (this.m_waiting && n >= 0) {
            String string2 = this.m_respBuffer.substring(0, n);
            this.m_respBuffer.delete(0, n + string.length());
            if (string2.indexOf(">>:") == 0) {
                String string3 = string2.substring(3);
                this.m_notDispatcher.dispatch(string3);
            } else if (string2.indexOf("**:") == 0) {
                this.m_resp = new InstrumentResponse(string2.substring(3), true);
                this.m_respComplete = true;
                if (this.m_debug) {
                    System.out.println("  ERR: " + this.m_resp.getResponse());
                }
            } else if (this.m_echoComplete) {
                if (!this.m_promptComplete) {
                    this.m_promptComplete = true;
                    this.m_respComplete = true;
                } else {
                    this.m_resp = new InstrumentResponse(string2, false);
                    if (this.m_debug) {
                        System.out.println("  RSP: " + this.m_resp.getResponse());
                    }
                    if (this.m_connection.getEndOfPrompt().length() == 0) {
                        this.m_respComplete = true;
                    } else {
                        this.m_promptComplete = false;
                    }
                }
            } else {
                this.m_echoComplete = true;
            }
            string = this.m_echoComplete ? (this.m_promptComplete ? this.m_connection.getEndOfResponse() : this.m_connection.getEndOfPrompt()) : "\r\n";
            n = this.m_respBuffer.indexOf(string);
        }
    }

    private class RcvThread
    extends Thread {
        public RcvThread() {
            this.setDaemon(true);
        }

        public void run() {
            RemoteInstrument.this.receive();
        }
    }
}

